﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.VistaWorker;
using BMS.VistaWorker.Data;
using BMS.VistaWorker.Reader.LogTables;
using BMS.VistaWorker.Abstract;


namespace BMS.VistaWorker.Reader.Concrete.Entities
{
    /// <summary>
    /// The display group log data.
    /// </summary>
    public class DisplayGroupLog : BaseLogData<DisplayGroupLog,DisplayGroup>
    {


        /// <summary>
        /// Gets the crud action.
        /// </summary>
        public override CrudAction CrudAction { get;  set; }


        /// <summary>
        /// Gets the id.
        /// </summary>
        public override int Id { get; set; }

        /// <summary>
        /// Gets or sets the action.
        /// </summary>
        /// <value>
        /// The action.
        /// </value>
        public char Action { get { return TranslateCrudAction.ToChar(CrudAction); } set { CrudAction = TranslateCrudAction.ToEnum(value); } }

        /// <summary>
        /// Gets the create date time.
        /// </summary>
        public override DateTime CreateDateTime { get; set; }

        /// <summary>
        /// Gets or sets the IEN.
        /// </summary>
        /// <value>
        /// The IEN.
        /// </value>
        public int IEN { get { return entity.IEN; } set { entity.IEN = value; } }
        /// <summary>
        /// Gets or sets the name.
        /// </summary>
        /// <value>
        /// The name.
        /// </value>
        public string Name { get { return entity.Name; } set { entity.Name = value; } }
        /// <summary>
        /// Gets or sets the name of the mixed.
        /// </summary>
        /// <value>
        /// The name of the mixed.
        /// </value>
        public string MixedName { get { return entity.MixedName; } set { entity.MixedName = value; } }
        /// <summary>
        /// Gets or sets the short name.
        /// </summary>
        /// <value>
        /// The short name.
        /// </value>
        public string ShortName { get { return entity.ShortName; } set { entity.ShortName = value; } }



    }
}
